<?php
namespace Filanco\RipnEpp\Model;

use DOMDocument;

/**
 * Class Domain
 * @package Filanco\RipnEpp\Model
 *
 * @method string getId()
 * @method string getRegistry()
 */
class Contact extends Api
{
    const
        FLAG_VERIFIED = 'verified';

    protected function fields()
    {
        return [
            'id' => 'Идентификатор',
            'registry' => 'Реестр',
        ];
    }

    /**
     * @param string $flag
     * @return Response
     */
    public function setFlag($flag)
    {
        $document = new DOMDocument('1.0', 'UTF-8');
        $command = $document->createElement('update');
        $contact = $document->createElement('contact:update');
        $contact->setAttribute('xmlns:contact', 'http://www.ripn.net/epp/ripn-contact-1.0');
        $contact->setAttribute('xsi:schemaLocation', 'http://www.ripn.net/epp/ripn-contact-1.0 ripn-contact-1.0.xsd');
        $contact->appendChild($document->createElement('contact:id', $this->getId()));

        $contact_update = $document->createElement('contact:chg');
        $contact_update->appendChild($document->createElement('contact:' . $flag));
        $contact->appendChild($contact_update);

        $command->appendChild($contact);
        $document->appendChild($command);
        $response = $this->send($command);

        return new Response($response);
    }

    protected function send($request)
    {
        return $this->client_manager->getClient($this->getRegistry())->send($request);
    }
}
