<?php
namespace Filanco\RipnEpp;

use Filanco\RipnEpp\Exception\ClientNotFoundException;

class ClientManager
{
    /** @var ClientManager */
    private static $instance;

    /** @var Client[] */
    private $clients;

    /**
     * ClientManager constructor.
     * @param array $clients
     */
    private function __construct(array $clients = [])
    {
        $this->clients = $clients;
    }

    private function __wakeup()
    {

    }

    private function __clone()
    {

    }

    /**
     * @param $registry
     * @return Client
     * @throws ClientNotFoundException
     */
    public function getClient($registry)
    {
        if (!isset($this->clients[$registry])) {
            throw new ClientNotFoundException($registry);
        }
        return $this->clients[$registry];
    }

    /**
     * @param array $clients
     * @return ClientManager
     */
    public static function getInstance(array $clients = [])
    {
        if (is_null(self::$instance)) {
            self::$instance = new self($clients);
        }
        return self::$instance;
    }

    /**
     * @param Client $client
     */
    public function registerClient(Client $client)
    {
        $this->clients[$client->registry] = $client;
    }
}
