<?php
namespace Filanco\RipnEpp\Exception\Registry;

use Exception;

/**
 * Class DomainAlreadyUndelegatedException
 * @package Filanco\RipnEpp\Exception\Registry
 */
class DomainAlreadyUndelegatedException extends Exception
{
    /**
     * DomainAlreadyUndelegatedException constructor.
     * @param int $code
     * @param string $domain_name
     * @param Exception|null $previous
     */
    public function __construct($domain_name, $code = 0, Exception $previous = null)
    {
        $message = 'Домен ' . $domain_name . ' уже разделегирован!';
        parent::__construct($message, $code, $previous);
    }
}
