<?php
namespace Filanco\RipnEpp\Exception\Registry;

use DOMElement;
use Exception;

/**
 * Class RequestLimitExceededException
 * @package Filanco\RipnEpp\Exception\Registry
 */
class RequestLimitExceededException extends BaseResponseErrorResultException
{
    /**
     * RequestLimitExceededException constructor.
     * @param DOMElement $result
     * @param int $code
     * @param Exception|null $previous
     */
    public function __construct(DOMElement $result, $code, Exception $previous = null)
    {
        parent::__construct($result, $code, $previous);
        $this->message = 'Превышено допустимое количество запросов!';
    }
}
