<?php
namespace Filanco\RipnEpp\Exception\Registry;

use DOMElement;
use Exception;

/**
 * Class SessionLimitExceededException
 * @package Filanco\RipnEpp\Exception\Registry
 */
class SessionLimitExceededException extends BaseResponseErrorResultException
{
    /**
     * SessionLimitExceededException constructor.
     * @param DOMElement $result
     * @param int $code
     * @param Exception|null $previous
     */
    public function __construct(DOMElement $result, $code, Exception $previous = null)
    {
        parent::__construct($result, $code, $previous);
        $this->message = 'Превышено допустимое количество сессий!';
    }
}
