<?php
use Filanco\RipnEpp\Client;
use Filanco\RipnEpp\ClientManager;
use Filanco\RipnEpp\Model\Contact;
use Filanco\RipnEpp\Model\Domain;

require_once __DIR__ . '/../vendor/autoload.php';

/**
 * Class EppFactory
 */
class EppFactory
{
    /**
     * @var ClientManager
     */
    private static $manager;
    private static $epp_config_location = 'registry.json';

    public static function getApi($class_name, $params)
    {
        if (!self::$manager) {
            $manager = ClientManager::getInstance();

            $registrars = json_decode(file_get_contents(self::$epp_config_location), true);

            foreach ($registrars as $registrar_params) {
                $manager->registerClient(new Client($registrar_params));
            }

            self::$manager = $manager;
        }

        return new $class_name(self::$manager, $params);
    }
}

/** @var Domain $api */
$api = EppFactory::getApi(Domain::class, ['domain_name' => 'domenus.ru']);
var_dump($api->getInfo());

/** @var Contact $api */
$api = EppFactory::getApi(Contact::class, ['id' => 'DMS324596', 'registry' => 'ru']);
var_dump($api->getInfo());
