<?php
namespace Filanco\RipnEpp\Exception\Registry;

use Exception;

/**
 * Class ResponseErrorResultException
 * @package Filanco\RipnEpp\Exception\Registry
 */
class ResponseErrorResultException extends Exception
{
    /** @var string */
    public $response_code;

    /** @var string */
    public $response_message;

    /**
     * ResponseErrorResultException constructor.
     * @param string $response_code
     * @param int $response_message
     * @param int $code
     * @param Exception|null $previous
     */
    public function __construct($response_code, $response_message, $code = 0, Exception $previous = null)
    {
        $message = 'Запрос в реестр завершился ошибочно с кодом ответа: ' . $response_code . ' и сообщением: ' . $response_message;
        parent::__construct($message, $code, $previous);
    }
}
