<?php
namespace Filanco\RipnEpp\Model;

use DOMDocument;
use DOMElement;
use TrueBV\Punycode;

class DomainInfoResponse extends Response
{
    /**
     * @var string
     */
    public $name;

    /**
     * @var string
     */
    public $registrant;

    /**
     * @var string
     */
    public $create_date;

    /**
     * @var string
     */
    public $update_date;

    /**
     * @var string
     */
    public $expire_date;

    /**
     * @var string
     */
    public $last_transfer_date;

    /**
     * @var string[]
     */
    public $statuses = [];

    /**
     * @var string[]
     */
    public $name_servers = [];

    /**
     * DomainInfoResponse constructor.
     * @param DOMDocument $response
     */
    public function __construct(DOMDocument $response)
    {
        parent::__construct($response);

        $date_format = 'Y-m-d H:i:s';
        $puny_code = new Punycode();
        $this->name = mb_strtolower($puny_code->decode($response->getElementsByTagName('name')->item(0)->textContent));
        $this->registrant = $response->getElementsByTagName('registrant')->item(0)->textContent;
        $this->create_date = date($date_format, strtotime($response->getElementsByTagName('crDate')->item(0)->textContent));
        $this->expire_date = date($date_format, strtotime($response->getElementsByTagName('exDate')->item(0)->textContent));
        $update_date = $response->getElementsByTagName('upDate');
        if ($update_date->length) {
            $this->update_date = date($date_format, strtotime($update_date->item(0)->textContent));
        }
        $last_transfer = $response->getElementsByTagName('trDate');
        if ($last_transfer->length) {
            $this->last_transfer_date = date($date_format, strtotime($last_transfer->item(0)->textContent));
        }
        $statuses_nodes = $response->getElementsByTagName('status');
        for ($i=0;$i<$statuses_nodes->length; $i++) {
            /** @var DOMElement $status_node */
            $status_node = $statuses_nodes->item($i);
            $this->statuses[] = $status_node->getAttribute('s');
        }
        $name_servers = $response->getElementsByTagName('hostObj');
        for ($i=0;$i<$name_servers->length; $i++) {
            /** @var DOMElement $name_server */
            $name_server = $name_servers->item($i);
            $this->name_servers[] = $name_server->nodeValue;
        }
    }
}