<?php
namespace Filanco\RipnEpp\Model;

use DOMDocument;
use DOMElement;

class BillingInfoResponse extends Response
{
    /**
     * @var float
     */
    public $sum;

    /**
     * @var float
     */
    public $credit;

    /**
     * @var string
     */
    public $calc_date;
    /**
     * @var string
     */
    public $currency;

    /**
     * BillingInfoResponse constructor.
     * @param DOMDocument $response
     */
    public function __construct(DOMDocument $response)
    {
        parent::__construct($response);

        $this->sum = (float)$response->getElementsByTagName('sum')->item(0)->nodeValue;
        $this->credit = (float)$response->getElementsByTagName('credit')->item(0)->nodeValue;
        $this->currency = $response->getElementsByTagName('currency')->item(0)->nodeValue;
        $calcDate = str_replace("\n", '', $response->getElementsByTagName('calcDate')->item(0)->nodeValue);
        $this->calc_date = date('Y-m-d H:i:s', strtotime($calcDate));
    }
}