<?php

namespace Filanco\RipnEpp\Model;

use DOMDocument;
use DOMElement;
use Filanco\RipnEpp\Model\ContactResponse\OrganizationContactInfoResponse;
use Filanco\RipnEpp\Model\ContactResponse\PersonContactInfoResponse;
use TrueBV\Punycode;

class ContactInfoResponse extends Response
{
    /**
     * @var string
     */
    public $contact_id;

    /**
     * person or organization
     * @var string
     */
    public $contact_type;

    /**
     * verified or unverified
     * @var string
     */
    public $confirmed;

    /**
     * @var string
     */
    public $create_date;

    /**
     * @var string
     */
    public $update_date;

    /**
     * @var string
     */
    public $oid_esia;

    /**
     * @var string[]
     */
    public $emails = [];

    /**
     * @var string
     */
    public $email_transfer;

    /**
     * @var string[]
     */
    public $phones = [];

    /**
     * @var string
     */
    public $phone_transfer;

    /**
     * @var string
     */
    public $phone_sms;

    /**
     * @var string[]
     */
    public $faxes = [];

    /**
     * @var string[]
     */
    public $statuses = [];

    /**
     * @var OrganizationContactInfoResponse|PersonContactInfoResponse
     */
    public $contact_info;

    /**
     * DomainInfoResponse constructor.
     * @param DOMDocument $response
     */
    public function __construct(DOMDocument $response)
    {
        parent::__construct($response);

        $date_format = 'Y-m-d H:i:s';

        $contact_id = $response->getElementsByTagName('id')->item(0);
        if ($contact_id !== null) {
            $this->contact_id = $contact_id->textContent;
        }

        $oid_esia = $response->getElementsByTagName('oidEsia')->item(0);
        if ($contact_id !== null) {
            $this->oid_esia = $oid_esia->textContent;
        }

        $type_organization = $response->getElementsByTagName('organization')->item(0);
        $type_person = $response->getElementsByTagName('person')->item(0);

        if ($type_organization !== null) {
            $this->contact_type = $type_organization->localName;
            $this->contact_info = new OrganizationContactInfoResponse($response);
        }

        if ($type_person !== null) {
            $this->contact_type = $type_person->localName;
            $this->contact_info = new PersonContactInfoResponse($response);
        }

        $confirmed = $response->getElementsByTagName('unverified')->item(0);
        if ($confirmed === null) {
            $confirmed = $response->getElementsByTagName('verified')->item(0);
        }
        $this->confirmed = $confirmed->localName;

        $create_date = $response->getElementsByTagName('crDate');
        if ($create_date->length) {
            $this->create_date = date($date_format, strtotime($create_date->item(0)->textContent));
        }

        $update_date = $response->getElementsByTagName('upDate');
        if ($update_date->length) {
            $this->update_date = date($date_format, strtotime($update_date->item(0)->textContent));
        }

        $emails = [];
        $emails_nodes = $response->getElementsByTagName('email');
        for ($i = 0; $i < $emails_nodes->length; $i++) {
            /** @var DOMElement $emails_nodes */
            $email = trim($emails_nodes->item($i)->textContent);

            if (preg_match('/(.*?)\(transfer\)/', $email, $matches)) {
                $email = trim($matches[1]);
                $this->email_transfer = $email;
            }

            $emails[] = $email;
        }
        $this->emails = array_unique($emails);

        $phones = [];
        $phones_nodes = $response->getElementsByTagName('voice');
        for ($i = 0; $i < $phones_nodes->length; $i++) {
            /** @var DOMElement $phones_nodes */
            $phone = trim(str_replace(' ', '', $phones_nodes->item($i)->textContent));

            if (preg_match('/(.*?)\(transfer\)/', $phone, $matches)) {
                $phone = trim($matches[1]);
                $this->phone_transfer = $phone;
            }

            if (preg_match('/(.*?)\(sms\)/', $phone, $matches)) {
                $this->phone_sms = trim($matches[1]);
                continue;
            }

            $phones[] = $phone;
        }
        $this->phones = array_unique($phones);

        $faxes_nodes = $response->getElementsByTagName('fax');
        for ($i = 0; $i < $faxes_nodes->length; $i++) {
            /** @var DOMElement $faxes_nodes */
            $this->faxes[] = str_replace(' ', '', $faxes_nodes->item($i)->textContent);
        }

        $statuses_nodes = $response->getElementsByTagName('status');
        for ($i = 0; $i < $statuses_nodes->length; $i++) {
            /** @var DOMElement $status_node */
            $status_node = $statuses_nodes->item($i);
            $this->statuses[] = $status_node->getAttribute('s');
        }
    }
}