<?php

namespace Filanco\RipnEpp\Model\ContactResponse;

use DOMDocument;
use TrueBV\Punycode;

class OrganizationContactInfoResponse
{
    /**
     * @var string
     */
    public $org_ru;

    /**
     * @var string
     */
    public $address_ru;

    /**
     * @var string
     */
    public $postal_address_ru;

    /**
     * @var string
     */
    public $org_en;

    /**
     * @var string
     */
    public $address_en;

    /**
     * @var string
     */
    public $inn;

    /**
     * OrganizationContactInfoResponse constructor.
     * @param DOMDocument $response
     */
    public function __construct(DOMDocument $response)
    {
        $legal_data = $response->getElementsByTagName('legalInfo')->item(0);
        $loc_data_ru = $response->getElementsByTagName('locPostalInfo')->item(0);
        $int_data_en = $response->getElementsByTagName('intPostalInfo')->item(0);

        $address_ru = $legal_data->getElementsByTagName('address')->item(0);
        if ($address_ru !== null) {
            $this->address_ru = $address_ru->textContent;
        }

        $org_ru = $loc_data_ru->getElementsByTagName('org')->item(0);
        if ($org_ru !== null) {
            $this->org_ru = $org_ru->textContent;
        }

        $postal_address_ru = $loc_data_ru->getElementsByTagName('address')->item(0);
        if ($postal_address_ru !== null) {
            $this->postal_address_ru = $postal_address_ru->textContent;
        }

        $org_en = $int_data_en->getElementsByTagName('org')->item(0);
        if ($org_en !== null) {
            $this->org_en = $org_en->textContent;
        }

        $address_en = $int_data_en->getElementsByTagName('address')->item(0);
        if ($address_en !== null) {
            $this->address_en = $address_en->textContent;
        }

        $inn = $response->getElementsByTagName('taxpayerNumbers')->item(0);
        if ($inn !== null) {
            $this->inn = $inn->textContent;
        }
    }
}