<?php

namespace Filanco\RipnEpp\Model\ContactResponse;

use DOMDocument;
use TrueBV\Punycode;

class PersonContactInfoResponse
{
    /**
     * @var string
     */
    public $name_ru;

    /**
     * @var string
     */
    public $address_ru;

    /**
     * @var string
     */
    public $name_en;

    /**
     * @var string
     */
    public $address_en;

    /**
     * @var string
     */
    public $birthday;

    /**
     * @var string
     */
    public $passport;

    /**
     * PersonContactInfoResponse constructor.
     * @param DOMDocument $response
     */
    public function __construct(DOMDocument $response)
    {
        $loc_data_ru = $response->getElementsByTagName('locPostalInfo')->item(0);
        $int_data_en = $response->getElementsByTagName('intPostalInfo')->item(0);

        $name_ru = $loc_data_ru->getElementsByTagName('name')->item(0);
        if ($name_ru !== null) {
            $this->name_ru = $name_ru->textContent;
        }

        $address_ru = $loc_data_ru->getElementsByTagName('address')->item(0);
        if ($address_ru !== null) {
            $this->address_ru = $address_ru->textContent;
        }

        $name_en = $int_data_en->getElementsByTagName('name')->item(0);
        if ($name_en !== null) {
            $this->name_en = $name_en->textContent;
        }

        $address_en = $int_data_en->getElementsByTagName('address')->item(0);
        if ($address_en !== null) {
            $this->address_en = $address_en->textContent;
        }

        $birthday = $response->getElementsByTagName('birthday');
        if ($birthday->length) {
            $this->birthday = date('Y-m-d', strtotime($birthday->item(0)->textContent));
        }

        $passport = $response->getElementsByTagName('passport')->item(0);
        if ($passport !== null) {
            $this->passport = $passport->textContent;
        }
    }
}