<?php
namespace Filanco\RipnEpp\Model;

use DOMDocument;
use DOMElement;
use DOMNodeList;

class Response
{
    /** @var DOMDocument */
    protected $response;

    /**
     * @var Result[]
     */
    public $results;

    /**
     * Response constructor.
     * @param DOMDocument $response
     */
    public function __construct(DOMDocument $response)
    {
        $this->response = $response;
        $results = $response->getElementsByTagName('result');
        for ($i=0; $i<$results->length; $i++) {
            /** @var DOMElement $result */
            $result = $results->item($i);
            $message = $result->getElementsByTagName('msg')->item(0)->textContent;
            $code = $result->getAttribute('code');
            $this->results[] = new Result(['code' => $code, 'message' => $message]);
        }
    }

    public function getResultData()
    {
        /**
         * @var $result_data DOMNodeList
         */
        $result_data = $this->response->getElementsByTagName('resData');
        if ($result_data->length > 0) {
            $result_data = $result_data->item(0);
        } else {
            $result_data = null;
        }

        return $result_data;
    }
}