<?php
namespace Filanco\RipnEpp\Exception\Registry;

use DOMElement;
use Exception;

/**
 * Class InvalidParameterValueException
 * @package Filanco\RipnEpp\Exception\Registry
 */
class InvalidParameterValueException extends BaseResponseErrorResultException
{
    /** @var string */
    public $parameter;

    /**
     * InvalidParameterValueException constructor.
     * @param DOMElement $result
     * @param int $code
     * @param Exception|null $previous
     */
    public function __construct(DOMElement $result, $code = 0, Exception $previous = null)
    {
        parent::__construct($result, $code, $previous);
        if (preg_match('/Element \'([^\']+)\'/mui', $result->nodeValue, $matches)) {
            $this->parameter = $matches[1];
        }
        $this->message = 'Не правильно указано значение параметра ' . $this->parameter;
    }
}
