<?php
namespace Filanco\RipnEpp\Model;

use DOMDocument;

/**
 * Class Domain
 * @package Filanco\RipnEpp\Model
 *
 * @method string getId()
 * @method string getRegistry()
 */
class Billing extends Api
{

    protected function fields()
    {
        return [
            'registry' => 'Реестр',
        ];
    }

    /**
     * @return BillingInfoResponse
     */
    public function getInfo($date = null)
    {
        if (empty($date)) {
            $date = date('Y-m-d');
        }
        $date = date('Y-m-d', strtotime($date));
        $document = new DOMDocument('1.0', 'UTF-8');
        $command = $document->createElement('info');
        $billing = $document->createElement('billing:info');
        $billing->setAttribute('xmlns:billing', 'http://www.tcinet.ru/epp/tci-billing-1.0');
        $billing->appendChild($document->createElement('billing:type', 'balance'));

        $params = $document->createElement('billing:param');
        $params->appendChild($document->createElement('billing:date', $date));
        $period = $document->createElement('billing:period', '1');
        $period->setAttribute('unit', 'd');
        $params->appendChild($period);
        $params->appendChild($document->createElement('billing:currency', 'RUB'));
        $billing->appendChild($params);

        $command->appendChild($billing);
        $document->appendChild($command);

        $response = $this->send($command);

        return new BillingInfoResponse($response);
    }

    /**
     * @return Response
     */
    public function getLimits()
    {
        $document = new DOMDocument('1.0', 'UTF-8');
        $command = $document->createElement('info');
        $limits = $document->createElement('limits:info');
        $limits->setAttribute('xmlns:limits', 'http://www.tcinet.ru/epp/tci-limits-1.0');
        $limits->setAttribute('xsi:schemaLocation', 'http://www.tcinet.ru/epp/tci-limits-1.0 tci-limits-1.0.xsd');
        $command->appendChild($limits);
        $document->appendChild($command);

        $response = $this->send($command);

        return new Response($response);
    }

    protected function send($request)
    {
        return $this->client_manager->getClient($this->getRegistry())->send($request);
    }
}
