<?php
namespace Filanco\RipnEpp\Model;

use DOMDocument;
use Filanco\RipnEpp\Exception\ClientNotFoundException;

/**
 * Class Domain
 * @package Filanco\RipnEpp\Model
 *
 * @method string getId()
 * @method string getRegistry()
 * @method AuthInfo getAuthInfo()
 */
class Contact extends Api
{
    const
        FLAG_VERIFIED = 'verified';

    protected function fields()
    {
        return [
            'id' => 'Идентификатор',
            'registry' => 'Реестр',
            'auth_info' => 'Авторизационный код',
        ];
    }

    /**
     * @param string $flag
     * @return Response
     * @throws ClientNotFoundException
     */
    public function setFlag($flag)
    {
        $document = new DOMDocument('1.0', 'UTF-8');
        $command = $document->createElement('update');
        $contact = $document->createElement('contact:update');
        $contact->setAttribute('xmlns:contact', 'http://www.ripn.net/epp/ripn-contact-1.0');
        $contact->setAttribute('xsi:schemaLocation', 'http://www.ripn.net/epp/ripn-contact-1.0 ripn-contact-1.0.xsd');
        $contact->appendChild($document->createElement('contact:id', $this->getId()));

        $contact_update = $document->createElement('contact:chg');
        $contact_update->appendChild($document->createElement('contact:' . $flag));
        $contact->appendChild($contact_update);

        $command->appendChild($contact);
        $document->appendChild($command);
        $response = $this->send($command);

        return new Response($response);
    }

    /**
     * @return ContactInfoResponse
     * @throws ClientNotFoundException
     */
    public function getInfo()
    {
        $document = new DOMDocument('1.0', 'UTF-8');
        $command = $document->createElement('info');
        $contact = $document->createElement('contact:info');
        $contact->setAttribute('xmlns:contact', 'http://www.ripn.net/epp/ripn-contact-1.0');
        $contact->setAttribute('xsi:schemaLocation', 'http://www.ripn.net/epp/ripn-contact-1.0 ripn-contact-1.0.xsd');
        $contact->appendChild($document->createElement('contact:id', $this->getId()));
        $auth_info = $this->getAuthInfo();
        if (!empty($auth_info)) {
            $auth_info_node = $document->createElement('contact:authInfo');
            $auth_info_value_node = $document->createElement('contact:pw');
            $auth_info_value_node->appendChild($document->createCDATASection($auth_info->getPw()));
            $auth_info_node->appendChild($auth_info_value_node);
            $contact->appendChild($auth_info_node);
        }

        $command->appendChild($contact);
        $document->appendChild($command);
        $response = $this->send($command);
        return new ContactInfoResponse($response);
    }

    /**
     * @param $request
     * @return DOMDocument
     * @throws ClientNotFoundException
     */
    protected function send($request)
    {
        return $this->client_manager->getClient($this->getRegistry())->send($request);
    }
}
