<?php

namespace Filanco\RipnEpp\Model\ContactResponse;

use DOMDocument;
use TrueBV\Punycode;

class OrganizationContactInfoResponse
{
    /**
     * @var string
     */
    public $org_ru;

    /**
     * @var string
     */
    public $address_ru;

    /**
     * @var string
     */
    public $postal_address_ru;

    /**
     * @var string
     */
    public $org_en;

    /**
     * @var string
     */
    public $address_en;

    /**
     * @var string
     */
    public $inn;

    /**
     * OrganizationContactInfoResponse constructor.
     * @param DOMDocument $response
     */
    public function __construct(DOMDocument $response)
    {
        $legal_data = $response->getElementsByTagName('legalInfo')->item(0);
        $loc_data_ru = $response->getElementsByTagName('locPostalInfo')->item(0);
        $int_data_en = $response->getElementsByTagName('intPostalInfo')->item(0);

        $address_ru_chunks = [];
        $address_ru = $legal_data->getElementsByTagName('address');
        for ($i = 0; $i < $address_ru->length; $i++) {
            /** @var DOMElement $address_ru */
            $address_ru_chunks[] = trim($address_ru->item($i)->textContent);
        }

        if (!empty($address_ru_chunks)) {
            $this->address_ru = implode(', ', array_filter($address_ru_chunks));
        }

        $org_ru = $loc_data_ru->getElementsByTagName('org')->item(0);
        if ($org_ru !== null) {
            $this->org_ru = $org_ru->textContent;
        }

        $postal_address_ru_chunks = [];
        $postal_address_ru = $loc_data_ru->getElementsByTagName('address');
        for ($i = 0; $i < $postal_address_ru->length; $i++) {
            /** @var DOMElement $postal_address_ru */
            $postal_address_ru_chunks[] = trim($postal_address_ru->item($i)->textContent);
        }

        if (!empty($postal_address_ru_chunks)) {
            $this->postal_address_ru = implode(', ', array_filter($postal_address_ru_chunks));
        }

        $org_en = $int_data_en->getElementsByTagName('org')->item(0);
        if ($org_en !== null) {
            $this->org_en = $org_en->textContent;
        }

        $address_en_chunks = [];
        $address_en = $int_data_en->getElementsByTagName('address');
        for ($i = 0; $i < $address_en->length; $i++) {
            /** @var DOMElement $address_en */
            $address_en_chunks[] = trim($address_en->item($i)->textContent);
        }

        if (!empty($address_en_chunks)) {
            $this->address_en = implode(', ', array_filter($address_en_chunks));
        }

        $inn = $response->getElementsByTagName('taxpayerNumbers')->item(0);
        if ($inn !== null) {
            $this->inn = $inn->textContent;
        }
    }
}