<?php

namespace Filanco\RipnEpp\Model\ContactResponse;

use DOMDocument;
use TrueBV\Punycode;

class PersonContactInfoResponse
{
    /**
     * @var string
     */
    public $name_ru;

    /**
     * @var string
     */
    public $address_ru;

    /**
     * @var string
     */
    public $name_en;

    /**
     * @var string
     */
    public $address_en;

    /**
     * @var string
     */
    public $birthday;

    /**
     * @var string
     */
    public $passport;

    /**
     * PersonContactInfoResponse constructor.
     * @param DOMDocument $response
     */
    public function __construct(DOMDocument $response)
    {
        $loc_data_ru = $response->getElementsByTagName('locPostalInfo')->item(0);
        $int_data_en = $response->getElementsByTagName('intPostalInfo')->item(0);

        $name_ru = $loc_data_ru->getElementsByTagName('name')->item(0);
        if ($name_ru !== null) {
            $this->name_ru = $name_ru->textContent;
        }

        $address_ru_chunks = [];
        $address_ru = $loc_data_ru->getElementsByTagName('address');
        for ($i = 0; $i < $address_ru->length; $i++) {
            /** @var DOMElement $address_ru */
            $address_ru_chunks[] = trim($address_ru->item($i)->textContent);
        }

        if (!empty($address_ru_chunks)) {
            $this->address_ru = implode(', ', array_filter($address_ru_chunks));
        }

        $name_en = $int_data_en->getElementsByTagName('name')->item(0);
        if ($name_en !== null) {
            $this->name_en = $name_en->textContent;
        }

        $address_en_chunks = [];
        $address_en = $int_data_en->getElementsByTagName('address');
        for ($i = 0; $i < $address_en->length; $i++) {
            /** @var DOMElement $address_en */
            $address_en_chunks[] = trim($address_en->item($i)->textContent);
        }

        if (!empty($address_en_chunks)) {
            $this->address_en = implode(', ', array_filter($address_en_chunks));
        }

        $birthday = $response->getElementsByTagName('birthday');
        if ($birthday->length) {
            $this->birthday = date('Y-m-d', strtotime($birthday->item(0)->textContent));
        }

        $passport_chunks = [];
        $passport = $response->getElementsByTagName('passport');
        for ($i = 0; $i < $passport->length; $i++) {
            /** @var DOMElement $passport */
            $passport_chunks[] = trim($passport->item($i)->textContent);
        }

        if (!empty($passport_chunks)) {
            $this->passport = implode(', ', array_filter($passport_chunks));
        }
    }
}