<?php
namespace Filanco\HalkApiClient\Module\Order;

use Filanco\HalkApiClient\Service\ApiClient;
use GuzzleHttp\Exception\GuzzleException;

class LedgerRepository
{
    /**
     * @var ApiClient
     */
    private $client;

    public function __construct(ApiClient $client)
    {
        $this->client = $client;
    }

    /**
     * @param array $params
     * @return Ledger[]
     * @throws GuzzleException
     */
    public function getByParams(array $params = [])
    {
        $server = null;

        $ledgers_rows = $this->client->send('panel.ledger.find', ['params' => $params]);

        $ledgers = [];

        foreach ($ledgers_rows as $ledger_row) {
            $ledger = $this->hydrate($ledger_row);
            $ledgers[] = $ledger;
        }

        return $ledgers;
    }

    /**
     * @param array $params
     * @return Ledger
     * @throws GuzzleException
     */
    public function getOne(array $params = [])
    {
        $server = null;

        $ledger_row = $this->client->send('panel.ledger.find_one', ['params' => $params]);

        $ledger = null;

        if ($ledger_row) {
            $ledger = $this->hydrate($ledger_row);
        }

        return $ledger;
    }

    /**
     * @param array $ledger_row
     * @return Ledger
     */
    private function hydrate(array $ledger_row)
    {
        $ledger = new Ledger();

        $ledger->id = $ledger_row['id'];
        $ledger->tariff_id = $ledger_row['tariff_id'];
        $ledger->period_type = $ledger_row['period_type'];
        $ledger->product_id = $ledger_row['product_id'];
        $ledger->product_price = $ledger_row['product_price'];
        $ledger->order_qty = $ledger_row['order_qty'];
        $ledger->pkg_type = $ledger_row['pkg_type'];
        $ledger->use_discount = $ledger_row['use_discount'];
        $ledger->description = $ledger_row['description'];
        $ledger->date_start = $ledger_row['date_start'];
        $ledger->date_end = $ledger_row['date_end'];
        $ledger->flags = $ledger_row['flags'];
        $ledger->amount = $ledger_row['amount'];
        $ledger->discount = $ledger_row['discount'];
        $ledger->total = $ledger_row['total'];
        $ledger->opening = $ledger_row['opening'];
        $ledger->credits = $ledger_row['credits'];
        $ledger->debits = $ledger_row['debits'];
        $ledger->closing = $ledger_row['closing'];

        return $ledger;
    }
}
