<?php
namespace Filanco\HalkApiClient\Module\Issue;

use Filanco\HalkApiClient\Service\ApiClient;
use GuzzleHttp\Exception\GuzzleException;

class IssueRepository
{
    /**
     * @var ApiClient
     */
    private $client;

    public function __construct(ApiClient $client)
    {
        $this->client = $client;
    }

    /**
     * @param array $params
     * @return Issue
     * @throws GuzzleException
     */
    public function getOne(array $params = [])
    {
        $issue = null;

        $issue_row = $this->client->send('panel.issue.find_one', ['params' => $params]);

        if ($issue_row) {
            $issue = new Issue();
            $issue->id = $issue_row['id'];
            $issue->subject = $issue_row['subject'];
        }

        return $issue;
    }
}
