<?php

use Filanco\HalkApiClient\Module\Order\Ledger;
use Filanco\HalkApiClient\Module\Order\LedgerRepository;
use Filanco\HalkApiClient\Module\Order\OrderRepository;
use Filanco\HalkApiClient\Module\Order\Service\EditOrder;

require_once __DIR__ . '/../../vendor/autoload.php';

$api_client = require_once __DIR__ . '/../api.php';

$order_repository = new OrderRepository($api_client);
$order = $order_repository->getOne(['id' => 11716559]);

$ledger = new Ledger();

$ledger->period_type = Ledger::PERIOD_TYPE_ONETIME;
$ledger->product_id = 7634900;// идентификатор номенклатуры телефонного трафика;
$ledger->product_price = 100; //цена за 1 пакет
$ledger->order_qty = 2; //количество пакетов
$ledger->description = 'Трафик по телефонии за октябрь 2018г.';
$ledger->date_start = '2018-10-01 00:00:00';
$ledger->amount = 200;//сумма за полный период без скидки
$ledger->discount = 0;//сумма скидки
$ledger->total = 200;//сумма за полный период с учетом скидки
$ledger->opening = 0;//неизрасходаванные средства на начало периода (пришедшие с предыдущего периода);
$ledger->credits = 200;//сумма за период (если период не полный, то будет меньше чем total)
$ledger->debits = 200;//сколько денег в этом периоде списано с лицевого счёта на оплату леджера
$ledger->closing = 0;//сколько неизрасходованных денег осталось после окончания периода

$add_product_to_order = new EditOrder($api_client, new LedgerRepository($api_client));
$ledger = $add_product_to_order->addProduct($order, $ledger, '2018-10-01', 'Увеличение количества номеров');

echo $ledger->id . PHP_EOL;
