<?php
namespace Filanco\HalkApiClient\Module\Order;

use Filanco\HalkApiClient\Service\ApiClient;
use GuzzleHttp\Exception\GuzzleException;

class OrderRepository
{
    /**
     * @var ApiClient
     */
    private $client;

    public function __construct(ApiClient $client)
    {
        $this->client = $client;
    }

    /**
     * @param array $params
     * @return Order
     * @throws GuzzleException
     */
    public function getOne(array $params = [])
    {
        $server = null;

        $order_row = $this->client->send('panel.order.find_one', ['params' => $params]);

        $order = null;

        if ($order_row) {
            $order = new Order();
            $order->id = $order_row['id'];
            $order->number = $order_row['number'];
            $order->owner_id = $order_row['owner_id'];
            $order->total = $order_row['total'];
            $order->total_discount = $order_row['total_discount'];
            $order->total_bonus = $order_row['total_bonus'];
            $order->status = $order_row['status'];
            $order->activated = $order_row['activated'];
            $order->suspended = $order_row['suspended'];
            $order->auto_renew = $order_row['auto_renew'];
            $order->base_type = $order_row['base_type'];
            $order->expire_time = $order_row['expire_time'];
            $order->tariff_id = $order_row['tariff_id'];
            $order->is_free = $order_row['is_free'];
            $order->parent_id = $order_row['parent_id'];
            $order->is_draft = $order_row['is_draft'];
            $order->balance = $order_row['balance'];
            $order->period = $order_row['period'];
            $order->period_type = $order_row['period_type'];
            $order->flags = $order_row['flags'];
            $order->bc_id = $order_row['bc_id'];
            $order->bca_id = $order_row['bca_id'];
            $order->politic_id = $order_row['politic_id'];
            $order->payment_type = $order_row['payment_type'];
        }

        return $order;
    }
}
