<?php
/**
 * User: r.mubarakzjanov
 * Date: 23.11.2018
 * Time: 15:22
 */

namespace Filanco\HalkApiClient\Module\Issue\Service;

use Filanco\HalkApiClient\Module\Issue\Comment;
use Filanco\HalkApiClient\Module\Issue\Issue;
use Filanco\HalkApiClient\Service\ApiClient;
use GuzzleHttp\Exception\GuzzleException;

class AddComment
{
    /**
     * @var ApiClient
     */
    private $api_client;

    public function __construct(ApiClient $api_client)
    {
        $this->api_client = $api_client;
    }

    /**
     * @param Issue $issue
     * @param Comment $comment
     * @throws GuzzleException
     */
    public function addComment(Issue $issue, Comment $comment)
    {
        $this->api_client->send('panel.issue.comment', [
            'id' => $issue->id,
            'description' => $comment->description,
        ]);
    }
}