<?php
namespace Filanco\HalkApiClient\Service;

use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;

class ApiClient
{
    /**
     * @var Client
     */
    private $client;
    private $login;
    private $password;

    public function __construct(Client $client, $login, $password)
    {
        $this->client = $client;
        $this->login = $login;
        $this->password = $password;
    }

    /**
     * @param $action
     * @param array $params
     * @return mixed
     * @throws Exception
     * @throws GuzzleException
     */
    public function send($action, array $params = [])
    {
        $response = $this->client->request(
            'POST',
            'http-rpc?'.$action,
            [
                'headers' => [
//                    'Cookie' => 'XDEBUG_SESSION=PHPSTORM'
                ],
                'form_params' => array_merge($params, [
                    'method' => $action,
                    'login' => $this->login,
                    'password' => $this->password,
                    'content_type' => 'json'
                ])
            ]
        );

        $response_body = $response->getBody()->getContents();

        $parsed_response_body = json_decode($response_body, 1);

        if (json_last_error()) {
            throw new Exception('Произошла ошибка во время разбора ответа!' . PHP_EOL . $response_body);
        }

        if (empty($parsed_response_body['success'])) {
            throw new Exception('Произошла ошибка во время выполнения запроса!' . PHP_EOL . $response_body);
        }

        return $parsed_response_body['data'];
    }
}