<?php
/**
 * Constant defining.
 *
 * PHP version 5.3
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Bootstrap
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    SVN: $Id: halk_constants.php 10012 2012-01-13 11:45:45Z i.kolombet $
 * @link       http://halk.filanco.ru
 */

/**
 * APP_ROOT (место расположение модулей)
 */
define('HALK_APP_ROOT', realpath(__DIR__));

/**
 * Имя приложения
 */
define('HALK_APPLICATION_NAME', 'Halk');

/**
 * Название ресурса шаблонизатора (halk:)
 */
define('HALK_TEMPLATE_PREFIX', 'halk');

define('LB_ORG', 1);
define('LB_PERSON', 2);
define('LB_ALL', 1 | 2);

define('DOMENUS_ORG', 8);
define('DOMENUS_IP', 16);
define('DOMENUS_PERSON', 32);
define('DOMENUS_ALL', 8 | 16 | 32);

define('HOSTER_ORG', 64);
define('HOSTER_IP', 128);
define('HOSTER_PERSON', 256);
define('HOSTER_ALL', 64 | 128 | 256);

define('REGION_MOSCOW', 1);
define('REGION_SPB', 2);
define('REGION_KRSN', 4);
define('REGION_KIEV', 8);
define('REGION_ALL', 1 | 2 | 4 | 8);

/**
 * STATUS_TYPE
 */
define('ENABLED', 'ENABLED');
define('DISABLED', 'DISABLED');
define('DELETED', 'DELETED');
define('SUSPENDED', 'SUSPENDED');
define('EXPIRED', 'EXPIRED');
define('GENERATE', 'GENERATE');
define('REGENERATE', 'REGENERATE');
define('READY', 'READY');
define('ERROR', 'ERROR');

/**
 * enum public.order_period
 */
define('PERIOD_DAILY', 'DAILY');
define('PERIOD_MONTHLY', 'MONTHLY');
define('PERIOD_YEARLY', 'YEARLY');
define('PERIOD_ONETIME', 'ONETIME');

/**
 * enum public.order_period to days
 * должно везде смотреть сюда. ибо были случаи когда надо было глобально изменить кол-во дней в году
 */
define('PERIOD_DAILY_TO_DAYS', 1);
define('PERIOD_MONTHLY_TO_DAYS', 30);
define('PERIOD_YEARLY_TO_DAYS', 365);
define('PERIOD_MONTH_12', 12);
define('PERIOD_MONTH_1', 1);
define('PERIOD_YEAR_1', 1);

define('ORDER_TYPE_VDS', 'VDS');
define('ORDER_TYPE_HOSTING', 'HOSTING');
define('ORDER_TYPE_DOMAIN', 'DOMAIN');
define('ORDER_TYPE_SSL', 'SSL');
define('ORDER_TYPE_IP', 'IP');
define('ORDER_TYPE_SERVERS', 'SERVERS');
define('ORDER_TYPE_COLLOCATION', 'COLLOCATION');
define('ORDER_TYPE_INTERNET', 'INTERNET');
define('ORDER_TYPE_INTERNET_BURST', 'INTERNET_BURST');
define('ORDER_TYPE_OTHER', 'OTHER');
define('ORDER_TYPE_TEL', 'TEL');
define('ORDER_TYPE_CVR', 'CVR');
define('ORDER_TYPE_TRANSPORT', 'TRANSPORT');


// за сколько дней можно продлять заказ
define('PROLONG_BEFORE_DAYS', 60);

// const account
define('ACCOUNT_TYPE_MAIN_ID', 1);
define('ACCOUNT_TYPE_BONUS_ID', 2);
define('ACCOUNT_TYPE_PARTNER_ID', 3);
define('ACCOUNT_TYPE_ELECTRON_ID', 4);
define('ACCOUNT_TYPE_CURRENCY_ID', 5);
define('ACCOUNT_TYPE_MAIN', 'main');
define('ACCOUNT_TYPE_BONUS', 'bonus');
define('ACCOUNT_TYPE_PARTNER', 'partner');
define('ACCOUNT_TYPE_ELECTRON', 'electron');
define('ACCOUNT_TYPE_CURRENCY', 'currency');
