<?php

use Halk\Core\Config;

$fileDir = dirname(__FILE__);
require_once $fileDir . '/bootstrap.php';

function set_eTagHeaders($file, $timestamp)
{
    $gmt_mTime = gmdate('r', $timestamp);

    header('Cache-Control: public');
    header('ETag: "' . md5($timestamp . $file) . '"');
    header('Last-Modified: ' . $gmt_mTime);

    if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) || isset($_SERVER['HTTP_IF_NONE_MATCH'])) {
        if ($_SERVER['HTTP_IF_MODIFIED_SINCE'] == $gmt_mTime ||
            str_replace('"', '', stripslashes($_SERVER['HTTP_IF_NONE_MATCH'])) == md5($timestamp . $file)) {
            header('HTTP/1.1 304 Not Modified');
            exit();
        }
    }
}

if (isset($_REQUEST['file'])) {

    if (strpos($_REQUEST['file'], '/') !== false) {
        list($dir, $module, $file) = preg_split("@[/]@", $_REQUEST['file'], 3);
    } else {
        // закрываемся от спама типо apple-touch-icon-precomposed.png
        exit;
    }

    if (preg_match('@^[A-Za-z0-9_-]+$@', $dir) && preg_match('@^[A-Za-z0-9_-]+$@', $module) && !strstr("..",
            $file) && preg_match('@^[A-Za-z0-9_/\.-]+$@', $file)
    ) {
        $ini = Config::getInstance();
        $module = ucfirst(strtolower($module));
        $on_disk_file = $ini->getValue('home') . '/' . $ini->getValue('smarty_template_dir') . '/Module/' . $module . '/View/' . $dir . '/' . $file;
        if (!file_exists($on_disk_file)) {
            $file = $ini->getValue('home') . '/' . $ini->getValue('smarty_template_dir') . '/Module/Core/View/' . $dir . '/' . $file;
        } else {
            $file = $on_disk_file;
        }
        if (file_exists($file)) {
            set_eTagHeaders($file, filemtime($file));
            $ext = end(explode('.', $file));
            if ($ext == 'js') {
                header('Content-Type: application/javascript');
            } else {
                if ($ext == 'css') {
                    header('Content-Type: text/css');
                } else {
                    if ($dir == 'img' || in_array($ext, array('jpg', 'jpeg', 'gif', 'png', 'tiff', 'bmp'))) {
                        if ($ext == 'svg') {
                            header('Content-Type: image/svg+xml');
                        } else {
                            header('Content-Type: ' . image_type_to_mime_type(exif_imagetype($file)));
                        }
                    }
                }
            }

            echo file_get_contents($file);
        }

        /*switch($dir) {
        case 'js':
            header('Content-Type: script/javascript');
            break;
        case 'css':
            header('Content-Type: text/css');
            break;
        case 'img':
            header('Content-Type: '.image_type_to_mime_type(exif_imagetype($file)));
            break;
        default:
            break;
        }*/

        exit;

    } elseif (is_null($file)) {
        //todo понять нет тут бага? щас думаю не сдесь
        $ini = Config::getInstance();
        $file = $ini->getValue('home') . '/' . $ini->getValue('smarty_template_dir') . '/Module/Core/View/' . $dir . '/' . $module;

        if (file_exists($file)) {
            $ext = end(explode('.', $file));
            if ($ext == 'js') {
                header('Content-Type: application/javascript');
            } else {
                if ($ext == 'css') {
                    header('Content-Type: text/css');
                } else {
                    if ($dir == 'img' || in_array($ext, array('jpg', 'jpeg', 'gif', 'png', 'tiff', 'bmp'))) {
                        if ($ext == 'svg') {
                            header('Content-Type: image/svg+xml');
                        } else {
                            header('Content-Type: ' . image_type_to_mime_type(exif_imagetype($file)));
                        }
                    }
                }
            }

            /*switch($dir) {
            case 'js':
                header('Content-Type: script/javascript');
                break;
            case 'css':
                header('Content-Type: text/css');
                break;
            case 'img':
                header('Content-Type: '.image_type_to_mime_type(exif_imagetype($file)));
                break;
            default:
                break;
            }*/
            echo file_get_contents($file);
            exit;
        }
    }

}
/*
$fp = fopen('../tmp/data.log', 'a+');
if ($fp) {
    fwrite($fp, var_export($_REQUEST, true) . "\n");
    fwrite($fp, "$_REQUEST[file]\n");
    fclose($fp);
}
*/