<?php

//ini_set('display_errors', 1);
//ini_set('error_reporting', E_ALL);
//set_time_limit(-1);

/**
 * Halk entry point.
 *
 * PHP version 5.3
 *
 * @category  PHP
 * @package   Bootstrap
 * @author    Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright 2011 Filanco
 * @license   Proprietary http://www.filanco.ru
 * @version   SVN: $Id: index.php 10725 2012-03-28 18:59:26Z i.kolombet $
 * @link      http://halk.filanco.ru
 */

define('HALK_START_TIME', microtime(true));

require_once 'bootstrap.php';


pf('bootstrap');

try {
    list($controller_name, $controller_method, $controller_params, $tpl_name, $tpls_dir, $module) = \Halk\Core\Router::route();

    if (!is_callable(array($controller_name, $controller_method))) {
        if (class_exists($controller_name) && $controller_name::$use_default_action) {
            $controller_method = HALK_CONTROLLER_ACTION_PREFIX. HALK_CONTROLLER_DEFAULT_METHOD_NAME;
            $req = explode('/', $_REQUEST['halk_command']);
            $controller_params = array_slice($req, 2);
            $tpl_name = 'halk:' . $module . ':' . $req[1] . '/' . HALK_CONTROLLER_DEFAULT_METHOD_NAME;
        } else {
            $controller_name = HALK_CONTROLLER_DEFAULT_STATIC_PAGE;
            $controller_method = HALK_CONTROLLER_ACTION_PREFIX . HALK_CONTROLLER_DEFAULT_METHOD_NAME;
        }
    }

    \Halk\Core\SignalHandler::listen('\Halk\Core\Controller', \Halk\Core\Controller::BEFORE_RENDER,
        function (\Halk\Core\Controller $controller) {
            $current_lang = \Halk\Core\LanguageSystem::getInstance()->run();

            if ($current_lang) {
                $controller->setTemplateDir('__' . $current_lang . '__');
            }
        });

    /**
     * @var $controller \Halk\Core\Controller
     */
    $controller = $controller_name::getInstance();

    if (!empty($tpls_dir)) {
        \Halk\Core\Smarty::getInstance()->addTemplateDir($tpls_dir);
    }
    $controller->setTemplate($tpl_name);
    $controller->before($controller_method);
    pf('before');

    $controller->$controller_method(is_null($controller_params) ? array() : $controller_params);
    pf($controller_method, 'before');
    $controller->after($controller_method);
    pf('after');

    $controller->requested_method = $controller_method;

//    try {
    if ($controller->request_type == \Halk\Core\Controller::REQUEST_TYPE_WWW) {
        $controller->render();
        pf('render');
    }
//    } catch (SmartyException $se) {
//        throw new Halk\Core\Exception\NotFoundException('К сожалению, такой страницы нет!');
//    }

    pf_log();

} catch (Exception $e) {
    $exceptionHandler = new \Halk\Core\Exception\Handler($e);
    $exceptionHandler->handle();
}

