<?php

namespace Halk\Core;

class GrayLogProjectProcessor
{
    /**
     * @var Config
     */
    protected $config;

    public function __construct()
    {
        $this->config = Config::getInstance();
    }

    public function __invoke(array $record)
    {
        if ($this->config->containsKey('graylog_project')) {
            $graylog_project = $this->config->getValue('graylog_project');
        } else {
            $www_base_url = $this->config->getValue('www_base_url');
            $graylog_project = preg_replace("(^https?://)", "", $www_base_url );
        }

        $record['extra']['graylog_project'] = $graylog_project;

        return $record;
    }
}
