<?php
namespace Halk\Core\Helper;

use Exception;
use Halk\Core\Config;

class ExceptionHelper
{
    /**
     * @param Exception $error
     * @return string
     */
    public static function getErrorMessageFromException($error)
    {
        $file = $error->getFile();
        if (defined('HALK_DOCUMENT_ROOT')) {
            $file = str_replace(HALK_DOCUMENT_ROOT, '.', $file);
        }

        $config = Config::getInstance();

        $trace = $error->getTraceAsString();

        if (
            !$config->containsKey('error_handler_include_arguments') ||
            !$config->getValue('error_handler_include_arguments')
        ) {
            $trace = preg_replace_callback('/\#[\d]+[^:]+\:[^(]+\((.*)\)/ui', function(array $matches){
                return str_replace($matches[1], '...args', $matches[0]);
            }, $trace);
        }

        return sprintf(
            "[%s] [%s:%s] %s\n%s",
            get_class($error),
            $file,
            $error->getLine(),
            $error->getMessage(),
            $trace
        );
    }

    /**
     * @param Exception $error
     * @return string
     */
    public static function convertExceptionToString(Exception $error)
    {
        $previous_exception = $error->getPrevious();
        $messages[] = static::getErrorMessageFromException($error);
        while (!is_null($previous_exception)) {
            $messages[] = static::getErrorMessageFromException($previous_exception);
            $previous_exception = $previous_exception->getPrevious();
        }
        return implode(PHP_EOL, $messages);
    }
}
