<?php

/**
 * Smarty modifier plugin
 *
 * Type: modifier<br>
 * Example: {$count|plural:'штука':'штуки':'штук'}
 * если $count=1, то выводится штука
 * если $count=2, то выводится штуки
 * если $count=6, то выводится штук
 * @return string
 * @version  1.0
 */
function smarty_modifier_plural()
{
    $args = func_get_args();
    $count = array_shift($args);
    $cases = [2, 0, 1, 1, 1, 2];
    return $args[($count % 100 > 4 && $count % 100 < 20) ? 2 : $cases[min($count % 10, 5)]];
}
