<?php namespace Halk\Core;

/**
 * JSON response class.
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    Release: 2.0
 * @link       http://halk.filanco.ru
 *
 */
class ResponseJSON {

    const ROOT_ELEMENT = 'result';

    /**
     *
     * @var integer
     */
    public $request_time;

    /**
     *
     * @var string
     */
    public $request_uri;

    /**
     *
     * @var array
     */
    public $data;

    /**
     *
     * @var array
     */
    public $errors;

    /**
     *
     * @var boolean
     */
    public $success;

    /**
     *
     * @var array
     */
    public $menu;

    public $debug;

    /**
     * Serialize as json.
     *
     * @return string json-string
     */
    public function serialize() {

        $array = array(self::ROOT_ELEMENT => 
            (array)$this
        );

        return json_encode($array);
    }//end serialize()
}//end class
