<?php
namespace Halk\Core;

/**
 * ActiveRecord interface.
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core_Interfaces
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    Release: 2.0
 * @link       http://halk.filanco.ru
 */
interface ActiveRecordInterface {

    /**
     * Get PK Value.
     *
     * @return mixed PK
     */
    public function getPKValue();
    
    /**
     * Load by PK.
     *
     * @return boolean true if OK
     *
     * @throws \Halk\Core\Exception\LoadException if can't load
     */
    public function load();

    /**
     * Save.
     *
     * @return boolean true if OK
     *
     * @throws \Halk\Core\Exception\SaveException if can't save
     * @throws \Halk\Core\Exception\ValidationError if invalid input
     */
    public function save();

    /**
     * Delete.
     *
     * @return true if OK
     *
     * @throws \Halk\Core\Exception\DeleteException if can't delete
     */
    public function delete();

    /**
     * Get collection of all objects from table.
     *
     * @param string $sort  key to sort by
     * @param string $table optional table to load from
     *
     * @return self[]
     */
    public static function getAll($sort = '', $table = null);

    /**
     * Get count of objects by params.
     *
     * @param array   $params sql params
     * @param integer $offset sql offset
     * @param integer $limit  sql limit (default -1 no limit)
     * @param string  $table  optional table to load from
     *
     * @return integer
     */
    public static function getCount(array $params = array(), $offset = 0, $limit = -1, $table = null);

    /**
     * Get collection of objects by params.
     *
     * @param array   $params sql params
     * @param integer $offset sql offset
     * @param integer $limit  sql limit (default -1 no limit)
     * @param string  $sort   key to sort by (default is PK)
     * @param string  $table  optional table to load from
     *
     * @return self[]
     */
    public static function getByParams(array $params = array(), $offset = 0, $limit = -1, $sort = '', $table = null);

    /**
     * Get first element by params.
     *
     * @param array   $params sql params
     * @param integer $offset sql offset
     * @param string  $sort   key to sort by (default is PK)
     * @param string  $table  optional table to load from
     *
     * @return ActiveRecord or null
     */
    public static function getOne(array $params = array(), $offset = 0, $sort = '', $table = null);

    /**
     * Get one object from table by certain field value.
     *
     * @param mixed  $value      value
     * @param string $field_name field name
     *
     * @return ActiveRecord or null
     */
    public static function getByField($value, $field_name = 'name');

    /**
     * Get object by primary key.
     * 
     * @param mixed $pk_value primary key value
     *
     * @return ActiveRecord or null
     */
    public static function getByPK($pk_value);

}//end interface
