<?php
namespace Halk\Core\Error;

use Halk\Core\Config;
use Monolog\Formatter\LineFormatter as MonologLineFormatter;

class ArgumentsSkippableLineFormatter extends MonologLineFormatter
{
    private $include_arguments;

    public function __construct(
        $format = null,
        $dateFormat = null,
        $allowInlineLineBreaks = false,
        $ignoreEmptyContextAndExtra = false
    ) {
        parent::__construct($format, $dateFormat, $allowInlineLineBreaks, $ignoreEmptyContextAndExtra);

        $config = Config::getInstance();

        if (
            $config->containsKey('error_handler_include_arguments') &&
            $config->getValue('error_handler_include_arguments')
        ) {
            $this->include_arguments = true;
        } else {
            $this->include_arguments = false;
        }

    }

    protected function normalizeException($e)
    {
        $normalized_exception = parent::normalizeException($e);
        if (!$this->include_arguments) {
            $normalized_exception = preg_replace_callback('/\#[\d]+[^:]+\:[^(]+\((.*)\)/ui', function(array $matches){
                return str_replace($matches[1], '...args', $matches[0]);
            }, $normalized_exception);
        }

        return $normalized_exception;
    }
}