<?php
namespace Halk\Core;

use Halk\Core\Config;
use Halk\Core\DBO;
use Halk\Core\DBOCassandra;
use Halk\Core\Exception\CoreException;

/**
 * Connection pool class.
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    Release: 2.0
 * @link       http://halk.filanco.ru
 */
class ConnectionPool extends Pool {

    /**
     *
     * @var string
     */
    public $entity = '\Halk\Core\DBO';

    /**
     * @var array
     */
    public $db_array = array();

    /**
     * @return array
     */
    private function __loadBasicServers() {

        $ini = Config::getInstance();
        $n = 1;

        for(;;) {

            if($ini->containsKey("db{$n}_connection_id")) {
                $db_name = $ini->getValue("db{$n}_name");
                $db_host = $ini->getValue("db{$n}_host");
                $db_user = $ini->getValue("db{$n}_user");
                $db_pass = $ini->getValue("db{$n}_pass");
                $db_port = $ini->containsKey("db{$n}_port") ?  $ini->getValue("db{$n}_port") : null;
                $db_engine = $ini->getValue("db{$n}_engine");
                $db_connection_id = $ini->getValue("db{$n}_connection_id");

            } else {

                break;
            }
             $this->db_array[$db_connection_id] = array($db_name, $db_host, $db_user, $db_pass, $db_engine, $db_port);
            //$dbo = new DBO($db_name, $db_host, $db_user, $db_pass, $db_engine, $db_connection_id);
            //$this->add($db_connection_id, $dbo);

            $n++;
        }
        return $this->db_array;
    }

    /**
     *
     */
    private function __loadCassandraServers() {

        $ini = Config::getInstance();
        $n = 1;

        for(;;) {

            if($ini->containsKey("cassandra{$n}_cluster_id")) {

                $hosts = explode(',', $ini->getValue("cassandra{$n}_hosts"));
                $ports = explode(',', $ini->getValue("cassandra{$n}_ports"));
                $cluster_id = $ini->getValue("cassandra{$n}_cluster_id");
                $keyspace = $ini->getValue("cassandra{$n}_keyspace");

            } else {

                break;
            }

            $dbo = new DBOCassandra($hosts, $ports, $keyspace, $cluster_id);

            $this->add($cluster_id, $dbo);

            $n++;
        }
    }

    /**
     * Load all connections from config.
     *
     * @uses Config
     *
     *
     * @throws CoreException
     * @return void
     */
    public function load() {

        try {

            $this->__loadBasicServers();

            //$this->__loadCassandraServers();

        } catch (CoreException $he) {

            throw $he;
        }
    }//end load()

    /**
     * Get connection by id.
     *
     * @param string $id connection Id (default=HALK_DEFAULT_CONNECTION_ID)
     *
     * @throws CoreException
     * @return \Halk\Core\DBO
     */
    public function get($id = HALK_DEFAULT_CONNECTION_ID) {

        if($this->contains($id)){

            return parent::get($id);

        } else {

            if(!isset($this->db_array[$id])) {
                throw new CoreException('Connection not found: ' . $id);
            }

            list($db_name, $db_host, $db_user, $db_pass, $db_engine, $db_port) = $this->db_array[$id];

            $dbo = new DBO($db_name, $db_host, $db_user, $db_pass, $db_engine, $id, $db_port);

            $this->add($id, $dbo);

            return $dbo;
        }
    }//end get()
}//end class
