<?php
namespace Halk\Core;

use Doctrine\DBAL\Cache\QueryCacheProfile;
use Doctrine\DBAL\Connection;

class DBALConnectionWrapper extends Connection
{
    public function executeQuery($query, array $params = [], $types = [], ?QueryCacheProfile $qcp = null)
    {
        if (ini_get('pinba.enabled')) {
            $query_timer = pinba_timer_start([
                'group' => 'sql_query',
                'query' => $query
            ]);
        }

        try {
            $result = parent::executeQuery($query, $params, $types, $qcp);
        } finally {
            if (ini_get('pinba.enabled')) {
                isset($query_timer) && pinba_timer_stop($query_timer);
            }
        }

        return $result;
    }

    public function executeUpdate($query, array $params = [], array $types = [])
    {
        if (ini_get('pinba.enabled')) {
            $query_timer = pinba_timer_start([
                'group' => 'sql_query',
                'query' => $query
            ]);
        }

        try {
            $result = parent::executeUpdate($query, $params, $types);
        } finally {
            if (ini_get('pinba.enabled')) {
                isset($query_timer) && pinba_timer_stop($query_timer);
            }
        }

        return $result;
    }

    public function exec($statement)
    {
        if (ini_get('pinba.enabled')) {
            $query_timer = pinba_timer_start([
                'group' => 'sql_query',
                'query' => $statement
            ]);
        }

        try {
            $result = parent::exec($statement); // TODO: Change the autogenerated stub
        } finally {
            if (ini_get('pinba.enabled')) {
                isset($query_timer) && pinba_timer_stop($query_timer);
            }
        }

        return $result;
    }


}