<?php

namespace Halk\Core;

/**
 * Router class.
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    Release: 2.0
 * @link       http://halk.filanco.ru
 */

class Router extends Registry
{
    /**
     * Get controller name from request URI.
     *
     * @return string
     */
    public static function getControllerName() {

        $params = $_REQUEST;

        if(isset($params['halk_command'])) {
            $command = $params['halk_command'];
            $command = trim($command, '/');

            if(strpos($command, '/') !== false) {

                return current(explode('/', $command, 2));

            } else {

                return $command;
            }
        }

        return HALK_CONTROLLER_DEFAULT_NAME;
    }//end getController_Name()

    /**
     * Get controller method name from request URI.
     *
     * @return string
     */
    public static function getControllerMethodName() {

        $params = $_REQUEST;

        if (isset($params['halk_command'])) {
            $command = $params['halk_command'];
            $command = trim($command, '/');

            if(strpos($command, '/') !== false) {
                return HALK_CONTROLLER_ACTION_PREFIX .
                str_replace('-', '_', next(explode('/', $command)));
            }
        }

        return HALK_CONTROLLER_ACTION_PREFIX . HALK_CONTROLLER_DEFAULT_METHOD_NAME;
    }//end getController_MethodName()

    /**
     * Get controller default method params from request URI.
     *
     * @return array or null
     */
    public static function getControllerMethodParams() {

        $params = $_REQUEST;

        if(isset($params['halk_command'])) {
            $command = $params['halk_command'];
            $command = trim($command, '/');

            if(strpos($command, '/') !== false) {

                $array = explode('/', $command);

                if(count($array) > 2) {
                    array_shift($array); // deleting controller name
                    array_shift($array); // deleting method name
                    return $array;
                }
            }
        }

        return HALK_CONTROLLER_DEFAULT_METHOD_PARAMS;
    }//end getController_MethodParams()


    /**
     *
     * Get all controller data at once.
     *
     * @return array
     * @throws Exception\INIException
     */
    public static function route()
    {
        $params = $_REQUEST;
        $tpl_separator = ':';//DIRECTORY_SEPARATOR;
        if (!empty($_SERVER['MODULE_PRIORITY'])) {
            $module_priority = $_SERVER['MODULE_PRIORITY'];
        } else if (Config::getInstance()->containsKey('module_priority')) {
            $module_priority = Config::getInstance()->getValue('module_priority');
        } else {
            $module_priority = null;
        }

        // -----------------------------------------------------------------------------------------------------------------------
        if (!empty($module_priority)) {
            $prefix_path_tpl = HALK_TEMPLATE_PREFIX.$tpl_separator.ucfirst($module_priority).$tpl_separator;
            $data = [
                'contr' => HALK_APPLICATION_NAME.'\\Module\\'.ucfirst($module_priority).'\\Controller\\Index',
                'action' => HALK_CONTROLLER_DEFAULT_METHOD_NAME,
                'params' => HALK_CONTROLLER_DEFAULT_METHOD_PARAMS,
                'tpl' => $prefix_path_tpl . HALK_CONTROLLER_DEFAULT_TEMPLATE_NAME,
                'tpls_dir' => null, //template dir
                'module' => null // Module name
            ];
        } else {
            $data = [
                'contr' => '',
                'action' => '',
                'params' => [],
                'tpl' => '',
                'tpls_dir' => null, //template dir
                'module' => null // Module name
            ];
        }

        if (!isset($params['halk_command'])) {
            $params['halk_command'] = '/index/index';
        }

        if (isset($params['halk_command'])) {
            $command = $params['halk_command'];
            $command = trim($command, '/');
            $req = explode('/', $command);

            if (!empty($req)) {
                $unknown = $req[0];

                $md = HALK_APP_ROOT . '/Module/';
                $mp = $md . ucfirst($unknown);
                $found = false;

                if (!empty($module_priority) && file_exists($md.ucfirst($module_priority)) && is_dir($md.ucfirst($module_priority))
                    && (file_exists($md.ucfirst($module_priority).'/Controller/'.ucfirst(strtolower($req[0])).'.php')) ) {
                    $module = $module_priority;
                    $data['contr'] = '\\'.HALK_APPLICATION_NAME.'\\Module\\' . ucfirst($module) . '\Controller\\' . ucfirst(strtolower($req[0]));
                    $dir = strtolower($req[0]) == strtolower($module) ? 'index' : strtolower($req[0]);
                    if (count($req) > 1) {
                        $data['action'] = $req[1];
                        $data['tpl'] = HALK_TEMPLATE_PREFIX . $tpl_separator . ucfirst($module) . $tpl_separator . $dir . '/' . $req[1];
                        $data['params'] = array_slice($req, 2);
                    } else {
                        $data['tpl'] = HALK_TEMPLATE_PREFIX . $tpl_separator. ucfirst($module) . $tpl_separator . $dir . '/index';
                    }
                    $data['module'] = ucfirst($module);
                    $found = true;
                } elseif (is_dir($md.ucfirst($req[0]))) {
                    $module_dir =  $md.ucfirst($req[0]);
                    $path = [];
                    $controller = '';
                    $tpl = '';
                    $level = 0;
                    list ($ctrl, $action) = array_pad($req, 2, null);
                    if ($action) {
                        $action = str_replace('-', '_', $action);
                    }
                    $ctrl = ucfirst($ctrl);

                    if (file_exists($module_dir.'/Controller/' . $ctrl . '.php')) {
                        $controller = '\\'.HALK_APPLICATION_NAME.'\\Module\\' . $ctrl . '\\Controller\\' . $ctrl;
                        $tpl = strtolower(HALK_TEMPLATE_PREFIX . $tpl_separator . $ctrl . $tpl_separator . 'index/'.(isset($action) ? $action:'index'));
                        $action = (isset($action) ? $action:'index');
                    } elseif (file_exists($module_dir.'/Controller/Index.php')) {
                        $controller = '\\'.HALK_APPLICATION_NAME.'\\Module\\' . $ctrl . '\\Controller\\Index';
                        $tpl = strtolower(HALK_TEMPLATE_PREFIX . $tpl_separator . $ctrl . $tpl_separator. 'index/'.(isset($action) ? $action:'index'));
                        $action = (isset($action) ? $action : 'index');
                    }


                    for ($i = 1, $req_length = count($req); $i < $req_length; $i++) {
                        $path[] = ucfirst($req[$i]);
                        // ищем контролер
                        if (file_exists($module_dir . '/Controller/' . implode("/", $path) . '.php')) {
                            $controller = '\\'.HALK_APPLICATION_NAME.'\\Module\\' . $ctrl . '\\Controller\\' . implode("\\", $path);
                            $tpl = HALK_TEMPLATE_PREFIX . $tpl_separator . $ctrl . $tpl_separator . implode("/", array_map('strtolower', $path));
                            $action  = (isset($req[$i+1]) ? str_replace('-', '_', $req[$i+1]) : 'index');
                            $tpl .= '/' . (isset($req[$i+1]) ? str_replace('-', '_', $req[$i+1]) :'index');
                            $level++;
                        }
                    }

                    if (!empty($controller)) {
                        $data['action'] = $action;
                        $data['contr'] = $controller;
                        $data['tpl'] = $tpl;
                        $data['params'] = array_slice($req, array_search($action, $req) + 1);
                        $found = true;
                    }
                }
                // если есть такой модуль, то маршрутизируем помодульно
                if (!$found && file_exists($mp) && is_dir($mp)) {
                    $module = &$unknown;

                    $req[1] = isset($req[1]) ? $req[1] : ucfirst($req[0]);
                    $req[2] = isset($req[2]) ? $req[2] : $data['action'];

                    $data['contr'] = '\\'.HALK_APPLICATION_NAME.'\\Module\\' . ucfirst($module) . '\Controller\\' .
                        ucfirst(strtolower($req[1]));

                    // FIX - есть контроллер Index - грузим его в первую очередь
                    if (!is_callable([$data['contr'], HALK_CONTROLLER_ACTION_PREFIX . $req[2]])) {
                        $data['contr'] = '\\'.HALK_APPLICATION_NAME.'\\Module\\' . ucfirst($module) . '\Controller\\Index' ;
                    }

                    // вызываемое действие
                    $data['action'] = $req[2];

                    $dir = strtolower($req[1]) == strtolower($module) ? 'index':strtolower($req[1]);

                    // определяем используемый шаблон
                    $data['tpl'] = HALK_TEMPLATE_PREFIX . $tpl_separator. ucfirst($module) . $tpl_separator . $dir . '/' . $req[2];
                    // определяем путь к модулям
                    // определяем параметры запроса
                    $data['params'] = array_slice($req, 3);

                    $found = is_callable([$data['contr'], HALK_CONTROLLER_ACTION_PREFIX . $req[2]]);
                }
            }
        }

        $data['action'] = HALK_CONTROLLER_ACTION_PREFIX . $data['action'];

        return array_values($data);
    }//end getControllerData()

    /**
     * Check if template exists.
     *
     * @param string $tpl template name
     *
     * @return boolean true if exists
     */
    public static function templateExists($tpl) {

        $tpls_dir = Config::getInstance()->getValue('smarty_template_dir');
        return file_exists($tpls_dir . $tpl . HALK_SMARTY_TEMPLATE_POSTFIX);
    }//end templateExists()

    /**
     * Access check to route.
     *
     * @param string $controller_name   controller name
     * @param string $controller_method controller method
     *
     * @return boolean true if access granted
     * @throws \Halk\Core\Exception\UnexpectedSituation
     */
    public static function checkACL($controller_name, $controller_method) {

        /**
         * @todo убрать заглушку
         */
        return true;
/*
        $controller_method = str_replace(self::HALK_CONTROLLER_ACTION_PREFIX, '', $controller_method);

        $user = User::getCurrentUser();
        $acl = HalkACLItem::getByController($controller_name, $controller_method);

        $result = null;

        if($user instanceof AnonymousUser) {

            $result = $acl->bit_position == 0;

        } elseif($user instanceof User) {

            if($user->is_superuser) {

                $result = $user->is_active;

            } else {

                $bit = intval($user->acl[intval($acl->bit_position)]);
                $result = ($bit == 1) && $user->is_active;
            }

        } else {

            $bit = intval($user->acl[intval($acl->bit_position)]);
            $result = ($bit == 1) && $user->is_active;
        }

        return $result;
       */
    }//end checkACL()
}//end class
