<?php
namespace Halk\Core;

use Halk\Core\Cache\CacheAdapter;
use Halk\Core\Cache\CacheFactory;

class QueryTimer
{
    public static function measure($query, callable $callable)
    {
        $config = Config::getInstance();
        if($config->containsKey('cache_driver')) {
            $driver = strtolower(trim($config->getValue('cache_driver')));
            if ($driver) {
                $cache = new CacheAdapter(CacheFactory::get($driver));
            }
        }

        if (ini_get('pinba.enabled')) {
            $query_hash = md5($query);

            if (isset($cache)) {
                $cache->set($query_hash, $query);
            }

            $query_timer = pinba_timer_start([
                'group' => 'sql_query',
                'query_hash' => $query_hash
            ]);
        }

        try {
            $result = $callable();
        } finally {
            if (ini_get('pinba.enabled')) {
                pinba_timer_stop($query_timer);
            }
        }

        return $result;
    }
}