<?php
/**
 * Created by PhpStorm.
 * User: a.tyutyunnikov
 * Date: 08.01.14
 * Time: 13:05
 */

namespace Halk\Core\DBO\Decorator;

use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Halk\Core\DBO;
use PDO;
use Halk\Core\Config as INI;
use Psr\Log\LoggerInterface;

class Log extends DBO
{
    private $logger = null;

    public function __construct($db_name, $db_host, $db_user, $db_pass, $db_engine, $db_connection_id, $db_port = null)
    {
        parent::__construct($db_name, $db_host, $db_user, $db_pass, $db_engine, $db_connection_id, $db_port);
    }

    public function query($q, array $params = array())
    {
        $this->_log($q, $params);
        return parent::query($q, $params);
    }

    public function getOne($q, array $params = array())
    {
        $this->_log($q, $params);
        return parent::getOne($q, $params);
    }

    public function fetchAll($q, array $params = array(), $mode = PDO::FETCH_ASSOC)
    {
        $this->_log($q, $params);
        return parent::fetchAll($q, $params, $mode);
    }

    public function getAll($q, array $params = array())
    {
        $this->_log($q, $params);
        return parent::getAll($q, $params);
    }

    public function getRow($q, array $params = array(), $mode = PDO::FETCH_ASSOC)
    {
        $this->_log($q, $params);
        return parent::getRow($q, $params, $mode);
    }

    protected function _log($q, array $params = [])
    {
        substr($q, -1) != ';' && $q .= ';';

        if(!($this->logger instanceof LoggerInterface)){
            $logger = new Logger(get_called_class());

            $config = new INI(HALK_DEFAULT_CONF, true);

            if($config->containsKey('logs')){
                $log_dir = $config->getValue('logs')['dir'];

                $log_file = $log_dir . DIRECTORY_SEPARATOR . 'sql' . DIRECTORY_SEPARATOR . 'pdo.' . date('Y-m-d', time()) . '.log';

                $logger->pushHandler(new StreamHandler($log_file, Logger::INFO));
            }

            $this->logger = $logger;
        }

        try{
            $this->logger->info($q, $params);
        } catch (\Exception $e){
            trigger_error($e->getMessage(), E_USER_ERROR);
        }
    }
} 
