<?php
namespace Halk\Core\Exception;

use Exception;

/**
 * Basic exception class.
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core_Exceptions
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    Release: 2.0
 * @link       http://halk.filanco.ru
 */
class CoreException extends Exception {

    /**
     * Сообщение ошибки
     *
     * @var string
     */
    private $messsage = '';

    /**
     * Constructor.
     *
     * @param string    $message  error message
     * @param integer   $code     error code
     * @param Exception $previous [optional] previous exception (default=null)
     */
    public function __construct($message, $code = 0, Exception $previous = null) {
        $this->messsage = $message;
        parent::__construct($message, $code, $previous);
    }

    /**
     * Метод получения сообщения ошибки
     *
     * @return string
     */

    public function get_message() {
        return $this->messsage;
    }
    //end __construct()
}//end class
