<?php

namespace Halk\Core;

use Redis;
use Throwable;

class QueryTimer
{
    private static function getCacheClient(): ?Redis
    {
        $client = null;

        $config = Config::getInstance();
        if ($config->containsKey('query_measure_redis_host')) {
            try {
                $client = new Redis();

                if (!$client->connect(
                    $config->getValue('query_measure_redis_host'),
                    $config->getValue('query_measure_redis_port'),
                    0.001
                )) {
                    return null;
                }

                if (
                    $config->containsKey('query_measure_redis_password')
                    && $redis_password = $config->getValue('query_measure_redis_password')
                ) {
                    if (!$client->auth($redis_password)) {
                        return null;
                    }
                }
            } catch (Throwable $e) {
                // не удалось подключиться к redis - не будем писать время запросов
            }
        }

        return $client;
    }

    public static function measure($query, callable $callable)
    {
        $config = Config::getInstance();
        $query_measure = $config->containsKey('query_measure') && $config->getValue('query_measure') && ini_get('pinba.enabled');
        $query_timer = null;
        if ($query_measure) {
            $cache_client = self::getCacheClient();
            $query_hash = md5($query);

            if ($cache_client) {
                try {
                    $cache_client->set($query_hash, $query, 60);
                } catch (Throwable $e) {
                    // - не получилось прописать в кеш запрос ничего страшного
                }
            }

            $query_timer = pinba_timer_start([
                'group' => 'sql_query',
                'query_hash' => $query_hash
            ]);
        }

        try {
            $result = $callable();
        } finally {
            if ($query_measure) {
                pinba_timer_stop($query_timer);
            }
        }

        return $result;
    }
}