<?php
namespace Halk\Core;

/**
 * ActiveRecord manager.
 *
 * Вспомогательный класс, хранит кеш построенных запросов
 *
 * PHP version 5.3
 *
 * @category   PHP
 * @package    Halk
 * @subpackage Core
 * @author     Kolombet Ivan <i.kolombet@hoster.ru>
 * @copyright  2011 Filanco
 * @license    Proprietary http://www.filanco.ru
 * @version    SVN: $Id: ActiveRecordManager.php 10514 2012-03-14 15:19:06Z i.kolombet $
 * @link       http://halk.filanco.ru
 */

class ActiveRecordManager {

    const HASH_PREFIX = '__hash__';

    static $__cache = array();

    /**
     * @static
     * @param $class
     * @param array $non_empty_default_fields
     * @param bool $only_this_class
     * @return mixed
     */
    public static function getUpdateFieldList($class, array $non_empty_default_fields, $only_this_class = false) {

        if(!isset(self::$__cache[$class::$connection_id])) {
            self::$__cache[$class::$connection_id] = array(
                'engine' => ConnectionPool::getInstance()->get($class::$connection_id)->engine,
            );
        }

        if(!isset(self::$__cache[$class::$connection_id][$class])) {
            self::$__cache[$class::$connection_id][$class] = array();
        }

        $hash = self::HASH_PREFIX . 
                implode('', array_keys($non_empty_default_fields)) .
                ($only_this_class ? '__ONLY__' : '__NOT_ONLY__');

        if(!isset(self::$__cache[$class::$connection_id][$class][$hash])) {
            self::$__cache[$class::$connection_id][$class][$hash] = array();
        }

        if(!isset(self::$__cache[$class::$connection_id][$class][$hash]['updateFieldList'])) {

            $fields = $only_this_class ? ActiveRecord::$__reflections[$class]['fields'] : $class::$fields;

            // Skip readonly fields
            $fields = array_filter($fields, function($x) {
                return !isset($x['readonly']) || !$x['readonly'] ;
            });

            $cache = self::$__cache[$class::$connection_id];
            $field_list = array_map(function($field, $prop) use ($cache, $non_empty_default_fields) {

                $setter = (isset($prop['default']) && !isset($non_empty_default_fields[$field])) ? ' = DEFAULT' : ' = ?';
                $field = SQLBuilder::escapeColumnName($field, $cache['engine']);

                return $field . $setter;

            }, array_keys($fields), array_values($fields));
            self::$__cache[$class::$connection_id][$class][$hash]['updateFieldList'] = $field_list;
        }

        return self::$__cache[$class::$connection_id][$class][$hash]['updateFieldList'];
    }

    /**
     * @static
     * @param $class
     * @param bool $pk_set
     * @param bool $only_this_class
     * @return mixed
     */
    public static function getInsertFieldList($class, $pk_set = false, $only_this_class = false) {

        if(!isset(self::$__cache[$class::$connection_id])) {
            self::$__cache[$class::$connection_id] = array(
                'engine' => ConnectionPool::getInstance()->get($class::$connection_id)->engine,
            );
        }

        if(!isset(self::$__cache[$class::$connection_id][$class])) {
            self::$__cache[$class::$connection_id][$class] = array();
        }

        $hash = self::HASH_PREFIX . 
                ($pk_set ? '__PK_SET__' : '__PK_NOT_SET__') .
                ($only_this_class ? '__ONLY__' : '__NOT_ONLY__');

        if(!isset(self::$__cache[$class::$connection_id][$class][$hash])) {
            self::$__cache[$class::$connection_id][$class][$hash] = array();
        }

        if(!isset(self::$__cache[$class::$connection_id][$class][$hash]['insertFieldList'])) {

            $fields = $only_this_class ? ActiveRecord::$__reflections[$class]['fields'] : $class::$fields;

            // Skip readonly fields
            $fields = array_filter($fields, function($x) {
                return !isset($x['readonly']) || !$x['readonly'];
            });

            $fields = array_keys($fields);

            if($pk_set) {

                if(is_array($class::$pk_field)) {
                    $fields = array_merge($fields, $class::$pk_field);
                } else {
                    $fields[] = $class::$pk_field;
                }
            }

            $cache = self::$__cache[$class::$connection_id];
            $field_list = array_map(function($x) use ($cache) {
                return SQLBuilder::escapeColumnName($x, $cache['engine']);
            }, $fields);

            self::$__cache[$class::$connection_id][$class][$hash]['insertFieldList'] = $field_list;
        }

        return self::$__cache[$class::$connection_id][$class][$hash]['insertFieldList'];
    }

    /**
     * @static
     * @param $class
     * @param array $non_empty_default_fields
     * @param bool $pk_set
     * @param bool $only_this_class
     * @return mixed
     */
    public static function getInsertPlaceholders($class, array $non_empty_default_fields, $pk_set = false, $only_this_class = false) {

        if(!isset(self::$__cache[$class::$connection_id])) {
            self::$__cache[$class::$connection_id] = array(
                'engine' => ConnectionPool::getInstance()->get($class::$connection_id)->engine,
            );
        }

        if(!isset(self::$__cache[$class::$connection_id][$class])) {
            self::$__cache[$class::$connection_id][$class] = array();
        }

        $hash = self::HASH_PREFIX .
                implode('', array_keys($non_empty_default_fields)) .
                ($pk_set ? '__PK_SET__' : '__PK_NOT_SET__') .
                ($only_this_class ? '__ONLY__' : '__NOT_ONLY__');

        if(!isset(self::$__cache[$class::$connection_id][$class][$hash])) {
            self::$__cache[$class::$connection_id][$class][$hash] = array();
        }

        if(!isset(self::$__cache[$class::$connection_id][$class][$hash]['insertPlaceholders'])) {

            $fields = $only_this_class ? ActiveRecord::$__reflections[$class]['fields'] : $class::$fields;

            // Skip readonly fields
            $fields = array_filter($fields, function($x) {
                return !isset($x['readonly']) || !$x['readonly'];
            });

            $placeholders = array_map(function($field, $prop) use ($non_empty_default_fields) {
                return ((isset($prop['default']) || $prop['type'] == 'serial') && !isset($non_empty_default_fields[$field])) ? 'DEFAULT' : '?';
            }, array_keys($fields), array_values($fields));

            if($pk_set) {

                if(is_array($class::$pk_field)) {
                    $placeholders = array_merge($placeholders, array_fill(0, count($class::$pk_field), '?'));
                } else {
                    $placeholders[] = '?';
                }
            }

            self::$__cache[$class::$connection_id][$class][$hash]['insertPlaceholders'] = $placeholders;
        }

        return self::$__cache[$class::$connection_id][$class][$hash]['insertPlaceholders'];
    }

    
}
