<?php
namespace Halk\Core\Helper;

class HttpHeader
{

    /**
     * Коды HTTP заголовков
     * @var $codes array
     */
    public static $codes = [
        400 => "HTTP/1.1 400 Bad Request",
        403 => "HTTP/1.1 403 Forbidden",
        404 =>  "HTTP/1.1 404 Not Found",
        500 => "HTTP/1.1 500 Internal Server Error"
    ];

    /**
     * Установка заголовка
     * @param $code
     */
    public static function setHeader($code)
    {
        if (array_key_exists($code, self::$codes)) {
            header(self::$codes[$code]);
        }
    }

    /**
     * Установка сообщения
     * @param $code
     * @return string
     */
    public static function setMessage($code)
    {
        if (array_key_exists($code, self::$codes)) {
            return strstr(
                "HTTP/1.1 ",
                self::$codes[$code],
                true
            );
        }

        return 'Unknown error';
    }
}