<?php
namespace Halk\Core;

class LanguageSystem extends Registry {

    protected $_enabled_langs = array();

    protected $_current_lang = null;

    public function __construct() {

        $ini = Config::getInstance();

        if($ini->containsKey('enabled_langs')) {
            $this->_enabled_langs = explode(',', $ini->getValue('enabled_langs'));
        }

        $this->_current_lang = empty($_COOKIE['lang']) ? null : $_COOKIE['lang'];
    }

    public function run() {
        // Переключение на новый язык
        $new_lang = RequestData::ob('_cl', null, true);

        if($new_lang) {
            // Язык поддерживается?
            if(!in_array($new_lang, $this->_enabled_langs)) {
                return $this->getDefaultLanguage();
            }

            // Переключаемся на язык
            $this->switchLanguage($new_lang);
        }

        return $this->getCurrentLanguage();
    }

    public function switchLanguage($lang) {

        if(!in_array($lang, $this->_enabled_langs)) {
            return;
        }

        setcookie('lang', $lang, time() + 3600 * 24 * 500, '/');
        $this->_current_lang = $lang;

        return $lang;
    }

    public function getDefaultLanguage() {
        unset($_COOKIE['lang']);
        setcookie('lang', "", time() - 900000);
        return null;
    }

    public function getCurrentLanguage() {
        return $this->_current_lang;
    }
}
