<?php
use Halk\Core\ConnectionPool;
use Halk\Core\LoadInterface;
use Halk\Core\Repository;

require_once __DIR__ . '/../../vendor/autoload.php';

const HALK_DEFAULT_CONF = __DIR__ . '/../Halk.ini';
const HALK_DEFAULT_CONNECTION_ID = 'main';

ConnectionPool::getInstance()->load();

class Issue implements LoadInterface
{
    protected $data = [];

    public function loadFromData($data)
    {
        $this->data = $data;
    }
}

class IssueRepository extends Repository
{
    protected static $search_params = [
        'id' => 'Идентификатор заявки',
        'author_title' => 'Автор',
        'subject' => 'Тема',
        'access_user_id' => 'Идентификатор пользователя',
        'project_id' => 'Проект',
        'tracker_id' => 'Трекер',
        'priority_id' => 'Приоритет',
        'status_id' => 'Статус',
        'is_deleted' => 'Удалена ли заявка',
        'assigned_to_id' => 'На кого назначена',
    ];

    public function search($limit = 50, $offset = 0)
    {
        $query = $this->buildSearchQuery($limit, $offset);

        return $this->getByQuery($query, []);
    }

    protected function buildSearchQuery($limit = 50, $offset = 0)
    {
        $dbal = $this->getDBO()->getDBAL();

        $view_builder = $dbal->createQueryBuilder();
        $view_builder
            ->select('access_user_issues.*')
            ->from('replace_access_user_issues', 'access_user_issues')
            ->join('access_user_issues', 'objects', 'access_user_issues_objects', 'access_user_issues_objects.id = access_user_issues.id')
            ->setMaxResults($limit)
            ->setFirstResult($offset);

        return $view_builder->getSQL();
    }

    protected function getTemplateObject(array $row = [])
    {
        return new Issue();
    }
}

$repository = new IssueRepository();

$issues = $repository->search(10, 0);
