<?php
namespace Halk\Core\Db;

use Closure;
use Throwable;
use Halk\Core\ConnectionPool;
use Halk\Core\DBO;

/**
 * Class Transaction
 * @package Halk\Core\Db
 */
class Transaction
{
    /**
     * Выполняет функцию внутри транзакции с учетом наличия уже открытых транзакций
     * @param Closure $function
     * @param DBO|null $dbo
     * @return mixed
     * @throws Throwable
     */
    public static function execute(Closure $function, DBO $dbo = null)
    {
        if (is_null($dbo)) {
            $dbo = ConnectionPool::getInstance()->get();
        }
        $in_parent_transaction = $dbo->inTransaction();
        if (!$in_parent_transaction) {
            $dbo->begin();
        }
        try {
            $result = $function();
            if (!$in_parent_transaction) {
                $dbo->commit();
            }
        } catch (Throwable $e) {
            if (!$in_parent_transaction && $dbo->inTransaction()) {
                $dbo->rollback();
            }
            throw $e;
        }

        return $result;
    }
}
