<?php
namespace Halk\Core\Smarty\Resource;

use Halk\Core\Config;
use Smarty\Template;
use Smarty\Template\Source;

class Halk extends \Smarty\Resource\CustomPlugin {

    protected $source;

    protected $templatePath;

    public function __construct()
    {
        $this->templatePath = Config::getInstance()->getValue('smarty_template_path');
    }

    protected function fetch($name, &$source, &$mtime)
    {

        $_dirs = $this->source->smarty->getTemplateDir();

        list($module, $tpl) = explode(":", $name, 2);

        foreach ($_dirs as $_dir) {
            $templatePath = sprintf($this->templatePath, ucfirst(strtolower($module)), $tpl);
            $file = $_dir . $templatePath;
            $file = str_replace('/', DIRECTORY_SEPARATOR, $file);

            if (file_exists($file)) {
                $source = file_get_contents($file);
                $mtime = filemtime($file);
                return;
            }
        }
    }

    protected function fetchTimestamp($name)
    {
        return null;
    }

    /**
     * populate Source Object with meta data from Resource
     *
     * @param Source   $source    source object
     * @param ?Template $_template template object
     */
    public function populate(Source $source, ?Template $_template = null)
    {
        $this->source = $source;
        $source->filepath = strtolower($source->type . ':' . $source->name);
        $source->uid = sha1($source->type . ':' . $source->name);

        $mtime = $this->fetchTimestamp($source->name);
        if ($mtime !== null) {
            $source->timestamp = $mtime;
        } else {
            $this->fetch($source->name, $content, $timestamp);
            $source->timestamp = isset($timestamp) ? $timestamp : false;
            if (isset($content))
                $source->content = $content;
        }
        $source->exists = !!$source->timestamp;
    }

}

