<?php
namespace Halk\Core\File;

/**
 * StorageInterface.
 * Интерфейс, обязательный для классов,
 * реализующих механизм хранения файлов.
 *
 * @package Halk
 * @subpackage File
 * @author Mikhail Levykin <zend53@yandex.ru>
 *
 */
interface StorageInterface
{
    /**
     * Метод, определяющий логику сохранения файла.
     *
     * @param FileObject $file_object Объект FileObject
     * @param Array $configs Необязательный массив дополнительных параметров
     * @access public
     * @return mixed
     */
    public function saveFile(FileObject $file_object, array $configs);
}

