<?php
namespace Halk\Core\Exception;

use Halk\Core\Helper\HttpHeader;
use Halk\Core\Rest\Exception\RestException;
use Halk\Core\Logger;
use Halk\Core\SignalHandler;

class Handler
{
    /**
     * Don't report these exception (log, render)
     * @var array
     */
    protected $dont_report = [
        'Halk\Core\Exception\InputException',
        'Halk\Core\Exception\ValidationError',
        'Halk\Core\Exception\Accessable',
        'Halk\Module\Panel\Exception\panelException',
    ];

    protected $exception;

    /**
     * @param \Exception $e
     */
    public function __construct(\Exception $e)
    {
        $this->exception = $e;
    }

    public function handle()
    {
        $dont_report = array_filter($this->dont_report, function ($exception) {
            return $this->exception instanceof $exception;
        });

        $fatal = empty($dont_report);

        //Exception must be reported
        if ($fatal) {
            Logger::exception($this->exception);
        }

        if ($this->exception instanceof RestException) {
            $this->respondRest();
        }

        SignalHandler::clear();

        $controller_name = HALK_CONTROLLER_DEFAULT_STATIC_PAGE;
        $controller_method = 'action_error';
        $tpl_name = HALK_TEMPLATE_PREFIX.':index:index/error';
        $controller = $controller_name::getInstance();

        if ($fatal && !($this->exception instanceof NotFoundException)) {
            $message = 'Произошла ошибка, обратитесь к разработчикам!';
            $code = 500;
        } else {
            $message = $this->exception->getMessage();
            $code = $this->exception->getCode();
        }

        $controller->$controller_method([
            'message' => $message,
            'code' => $code
        ]);

        $controller->setTemplateDir(null);
        $controller->setTemplate($tpl_name);

        $controller->requested_method = $controller_method;
        if ($controller->request_type == $controller::REQUEST_TYPE_WWW) {
            HttpHeader::setHeader($code);
            $controller->render();
        }

        pf_log();
    }

    public function respondRest()
    {
        $code = $this->exception->getCode();
        HttpHeader::setHeader($code);
        print HttpHeader::setMessage($code);
        pf_log();
        exit;
    }
}