<?php
namespace Halk\Core\Helper;

use Exception;

class ExceptionHelper
{
    public static function getErrorMessageFromException(Exception $e)
    {
        $file = $e->getFile();
        if (defined('HALK_DOCUMENT_ROOT')) {
            $file = str_replace(HALK_DOCUMENT_ROOT, '.', $file);
        }
        return sprintf(
            "[%s] [%s:%s] %s\n%s",
            get_class($e),
            $file,
            $e->getLine(),
            $e->getMessage(),
            $e->getTraceAsString()
        );
    }

    public static function convertExceptionToString(Exception $e)
    {
        $previous_exception = $e->getPrevious();
        $messages[] = static::getErrorMessageFromException($e);
        while (!is_null($previous_exception)) {
            $messages[] = static::getErrorMessageFromException($previous_exception);
            $previous_exception = $previous_exception->getPrevious();
        }
        return implode(PHP_EOL, $messages);
    }
}
