<?php
namespace Tests\Halk\Core\Helper;

use DateTime;
use Halk\Core\Helper\HalkDate;
use PHPUnit_Framework_TestCase;

class HalkDateTest extends PHPUnit_Framework_TestCase
{
    public function testInPeriodTrue()
    {
        $current_time = new DateTime("2016-01-01 00:00:00");
        $left_border = "2015-12-31 23:59:59";
        $right_border = "2016-01-01 00:00:01";
        $in_period = HalkDate::inPeriod($left_border, $right_border, $current_time);
        $this->assertTrue($in_period);
    }

    public function testInPeriodFalse()
    {
        $current_time = new DateTime("2016-01-01 00:00:00");
        $left_border = "2015-12-31 23:59:58";
        $right_border = "2015-12-31 23:59:59";
        $in_period = HalkDate::inPeriod($left_border, $right_border, $current_time);
        $this->assertFalse($in_period);
    }
}
